<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Enqueue parent and child theme styles
function flairstonelending_enqueue_styles() {
    $parent_style = 'astra-style';

    wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css');
    wp_enqueue_style('flairstone-lending-style', get_stylesheet_directory_uri() . '/style.css', array($parent_style), wp_get_theme()->get('Version'));
}
add_action('wp_enqueue_scripts', 'flairstonelending_enqueue_styles');


// For Apply Online 

function add_custom_footer_jquery_script() {
    ?>
    <script>
    jQuery(document).ready(function(){
        jQuery(".step_1_btn").click(function(){
            jQuery(".step_2").fadeOut("400");
            jQuery(".step_3").fadeOut("400");
            jQuery(".step_1").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").addClass("active");
            jQuery(".info_li_2").removeClass("active");
            jQuery(".info_li_3").removeClass("active");
        });
        jQuery(".step_2_btn").click(function(){
            jQuery(".step_1").fadeOut("400");
            jQuery(".step_3").fadeOut("400");
            jQuery(".step_2").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").removeClass("active");
            jQuery(".info_li_2").addClass("active");
            jQuery(".info_li_3").removeClass("active");
        });
        jQuery(".step_3_btn").click(function(){
            jQuery(".step_1").fadeOut("400");
            jQuery(".step_2").fadeOut("400");
            jQuery(".step_3").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").removeClass("active");
            jQuery(".info_li_2").removeClass("active");
            jQuery(".info_li_3").addClass("active");
        });
    });
    </script>
    <?php
}

add_action('wp_footer', 'add_custom_footer_jquery_script', 100);




// Add scripts and styles for custom button toggle functionality in the footer
function enqueue_custom_toggle_scripts_footer() {
    // Inline JavaScript for the toggle functionality
    $custom_js = "
        document.addEventListener('DOMContentLoaded', () => {
          // Select buttons by their IDs
          const personalButton = document.getElementById('Personal-Financing');
          const businessButton = document.getElementById('Business-Financing');
          const mortgageButton = document.getElementById('Mortgage-Financing');
          const badCreditButton = document.getElementById('Bad-Credit-Financing');

          // Select content containers by their IDs
          const personalContent = document.getElementById('Personal-Financing-content');
          const businessContent = document.getElementById('Business-Financing-content');
          const mortgageContent = document.getElementById('Mortgage-Financing-content');
          const badCreditContent = document.getElementById('Bad-Credit-Financing-content');

          // Hide all content and show only the selected content
          function showContent(event, selectedContent) {
            event.preventDefault(); // Prevent the default behavior of the button
            event.stopPropagation(); // Stop event propagation
            
            personalContent.classList.remove('active');
            businessContent.classList.remove('active');
            mortgageContent.classList.remove('active');
            badCreditContent.classList.remove('active');

            selectedContent.classList.add('active');
          }

          // Initialize: Show Personal Financing content by default
          personalContent.classList.add('active');

          // Add event listeners to buttons
          personalButton.addEventListener('click', (event) => showContent(event, personalContent));
          businessButton.addEventListener('click', (event) => showContent(event, businessContent));
          mortgageButton.addEventListener('click', (event) => showContent(event, mortgageContent));
          badCreditButton.addEventListener('click', (event) => showContent(event, badCreditContent));
        });
    ";

    // Inline CSS for styling content containers
    $custom_css = "
        #Personal-Financing-content,
        #Business-Financing-content,
        #Mortgage-Financing-content,
        #Bad-Credit-Financing-content {
          display: none;
          box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        #Personal-Financing-content.active,
        #Business-Financing-content.active,
        #Mortgage-Financing-content.active,
        #Bad-Credit-Financing-content.active {
          display: block;
        }
    ";

    // Output JavaScript and CSS in the footer
    echo '<style>' . $custom_css . '</style>';
    echo '<script>' . $custom_js . '</script>';
}
add_action('wp_footer', 'enqueue_custom_toggle_scripts_footer');
